/******************************************************************************
* File:    isr.h
* 
* Purpose: Define interrupt service routines referenced by the vector table.
* Author:  Quinten Brooks, Freescale Semiconductor
* Email:   quinten.brooks@freescale.com
* Date:    2007.03.21
*******************************************************************************
*
* To declare an Interrupt Service Routine (ISR):
*
*    1.) Undefine the appropriate "VECTOR_XXX" macro.
*    2.) Re-define the "VECTOR_XXX" macro as the ISR function name.
*    3.) Make the ISR function globally visable via "extern".
*    4.) Define the ISR in "isr.c"
*
* Note: Only "vectors.c" should include this header file.
******************************************************************************/

#ifndef __ISR_H
#define __ISR_H 1

// This is an example of how to define custom ISRs in the vector table.
//#undef  VECTOR_014
//#define VECTOR_014  pwm_reload_isr
#undef  VECTOR_023
#define VECTOR_023  iic_isr

// Define code segment for ISRs (referenced in linker command file).
#pragma define_section INTERRUPT_SERVICE_ROUTINES "isr.text" RX

// All Reset vector(s) are defined in "cpu.c".
extern void entry_point(void);

// ISR(s) are defined in "isr.c".
extern void default_isr(void);
extern void fast_isr(void);
extern void pwm_reload_isr(void);
extern void iic_isr(void);

#endif  __ISR_H

/* End of "isr.h" */
